IF OBJECT_ID('P_EST_NF_SAI_NF_ENT_ANALISE') IS NOT NULL
    BEGIN
	   DROP PROCEDURE P_EST_NF_SAI_NF_ENT_ANALISE
    END
GO
CREATE PROCEDURE P_EST_NF_SAI_NF_ENT_ANALISE (@CD_FILIAL VARCHAR (MAX),@CD_MOV_OP VARCHAR (MAX),@DT_INI DATETIME,@DT_FIM DATETIME)
AS 
SET NOCOUNT ON;

/*
--DROP TABLE #RESULT,#AUX
P_EST_NF_SAI_NF_ENT_ANALISE '90','11','09/01/2018','09/30/2018'
 DECLARE @DT_INI DATETIME = '09/01/2018',@DT_FIM DATETIME ='09/30/2018'  ,@CD_MOV_OP VARCHAR (MAX)='11',
  @CD_FILIAL VARCHAR (MAX)='90'
 */
	   CREATE TABLE #FILIAIS
	   (CD_EMP    INT,
	    CD_FILIAL INT
	   );
	   CREATE TABLE #MOV
	   (CD_EMP    INT,
	    CD_MOV_OP INT
	   );
	   INSERT INTO #FILIAIS
			SELECT 1,
				  ID
			FROM UFD_PRM_IN_STRING(@CD_FILIAL);
	   INSERT INTO #MOV
			SELECT 1,
				  ID
			FROM UFD_PRM_IN_STRING(@CD_MOV_OP);
	    CREATE TABLE #RESULT
	   (CD_EMP                 INT,
	    CD_FILIAL              INT,
	    CD_NF                  INT,
	    CD_CLI_FILIAL          INT,
	    NM_DEST                VARCHAR(255),
	    NF_NF                  INT,
	    DT_EMI_NF              DATETIME,
	    CD_PROD                INT,
	    DS_PROD			    VARCHAR(150),
	    NM_FABRIC              VARCHAR(150),
	    DS_ARV_MERC_CATEG      VARCHAR(150),
	    DS_ARV_MERC_DEPTO      VARCHAR(150),
	    DS_ARV_MERC_AREA_ATEND VARCHAR(150),
	    DS_ARV_MERC_SEG        VARCHAR(150),
	    DS_ARV_MERC_LINHA      VARCHAR(150),
	    DS_ARV_MERC_PAPEL      VARCHAR(150),
	    DS_ARV_MERC_FAMILIA    VARCHAR(150),
	    DS_ARV_MERC_MIX        VARCHAR(150),
	    DS_ARV_MERC_CONSUMO    VARCHAR(150),
	    STS_NF                 VARCHAR(50),
	    CD_MOV_OP              INT,
	    DS_MOV_OP_USUAL        VARCHAR(150),
	    BX_EST                 VARCHAR(50),
	    TIPO_TRANSACAO         VARCHAR(50),
	    QT_IT                  MONEY,
	    VLR_TOT_IT_BRT         MONEY,
	    VLR_TOT_IT             MONEY,
	    VLR_DESC_IT            MONEY,
	    VLR_IPI_IT             MONEY,
	    CD_TRIB_FC             MONEY,
	    VLR_BASE_ICMS_IT       MONEY,
	    ALIQ_ICMS              MONEY,
	    VLR_ICMS_IT            MONEY,
	    LISTA_PROD             VARCHAR(30),
	    CFOP                   VARCHAR(150),
	    NR_NCM                 VARCHAR(150),
	    VLR_PAUTA_IVA          MONEY,
	    VLR_BASE_SUBS_IT       MONEY,
	    VLR_ICMS_SUBS_IT       MONEY,
	    VLR_TOT_IT_NOTA        MONEY,
	    VLR_CUSTO_IT_MD        MONEY,
	    VLR_TABELA             MONEY,
	    VLR_CUSTO_GRP          MONEY,
	    VLR_CUSTO_MD           MONEY,
	    OBS1                   VARCHAR(150),
	    OBS2                   VARCHAR(150),
	    OBS3                   VARCHAR(150),
	    OBS4                   VARCHAR(150),
	    CGC_CPF                VARCHAR(50),
	    UF                     VARCHAR(4),
	    ESPC                   VARCHAR(150),
	    SERIE                  VARCHAR(150),
	    PEND_ENTRADA           VARCHAR(10),
	    NR_PROTOCOLO           VARCHAR(50),
	    NR_AUTORIZADOR         VARCHAR(60),
	    XML_ARM_NF             VARCHAR(10),
	    VLR_ICMS_RET           MONEY,
	    PIS_COFINS             VARCHAR(3),
	    VLR_NF                 MONEY,
	    NOTAENTRADA            TINYINT,
	    DT_ENT                 DATETIME,
	    NF_ENT_REF             INT,
	    DT_ENT_REF             INT,
	    QT_IT_REF              INT,
	    VLR_ISENTO             MONEY,
	    VLR_OUTROS             MONEY,
	    VLR_OUTROS_DESPESAS    MONEY,
	    VLR_ICMS_RECUPERAR     MONEY,
	    NR_CEST                VARCHAR(150),
	    NM_USU                 VARCHAR(150)
	   );

	   CREATE TABLE #AUX 
	   (
	   CD_EMP INT ,
	   CD_FILIAL INT,
	   CD_NF INT,
	   CD_PROD INT,
	   VLR_ICMS_REC MONEY
	   ) 
-----------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------
INSERT INTO #AUX

    SELECT I.CD_EMP,
          I.CD_FILIAL,
          I.CD_NF,
          I.CD_PROD,
          SUM(S.QT_IT * S.VLR_BASE_ICMS_ST) * .17 VLR_ICMS_REC
    FROM EST_NF_SAI_IT I
        INNER JOIN EST_NF_SAI_IT_EST_PROD_CPL_TRIB_ST_DEB D ON I.CD_EMP = D.CD_EMP
                                                                AND I.CD_FILIAL = D.CD_FILIAL
                                                                AND I.CD_PROD = D.CD_PROD
                                                                AND I.CD_IT = D.CD_IT
                                                                AND I.CD_NF = D.CD_NF
        INNER JOIN EST_PROD P ON D.CD_EMP = P.CD_EMP
                                  AND D.CD_PROD = P.CD_PROD
        INNER JOIN EST_PROD_CPL_TRIB_ST_DEB S ON D.CD_CTR = S.CD_CTR
	   INNER JOIN #FILIAIS ON I.CD_EMP = #FILIAIS.CD_EMP 
						 AND I.CD_FILIAL = #FILIAIS.CD_FILIAL 
    WHERE 
	   I.CD_EMP = 1 
	   AND I.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
	   AND ISNULL(P.FLAG_PERMITE_RESSARCIMENTO_ICMS, 0) = 1
    GROUP BY I.CD_EMP,
            I.CD_FILIAL,
            I.CD_NF,
            P.NR_CEST,
            I.CD_PROD

-----------------------------------------------------------------------------------------------------------------------------------------------------------
PRINT 'INSERT 1 ' +CONVERT (VARCHAR,GETDATE(),108)
-----------------------------------------------------------------------------------------------------------------------------------------------------------

INSERT INTO #RESULT

SELECT S.CD_EMP,
      S.CD_FILIAL,
	 S.CD_NF,
      S.CD_CLI_FILIAL AS CD_CLI,
      S.NM_DEST,
      S.NF_NF,
      S.DT_EMI_NF,
      A.CD_PROD,
      A.DS_PROD,
      A.NM_FABRIC,
      A.DS_ARV_MERC_CATEG,
      A.DS_ARV_MERC_DEPTO,
      A.DS_ARV_MERC_AREA_ATEND,
      A.DS_ARV_MERC_SEG,
      A.DS_ARV_MERC_LINHA,
      A.DS_ARV_MERC_PAPEL,
      A.DS_ARV_MERC_FAMILIA,
      A.DS_ARV_MERC_MIX,
      A.DS_ARV_MERC_CONSUMO,
      CASE
          WHEN S.STS_NF = 0
          THEN 'ATIVA'
          ELSE 'CANCELADA'
      END AS STS_NF,
      S.CD_MOV_OP,
      S.DS_MOV_OP_USUAL,
      CASE
          WHEN S.BX_EST = 1
          THEN 'BAIXOU ESTOQUE'
          ELSE 'NO BAIXOU ESTOQUE'
      END AS BX_EST,
      'SAIDA' AS TIPO_TRANSACAO,
      S.QT_IT,
      (S.VLR_TOT_IT + S.VLR_DESC_IT) AS VLR_TOT_IT_BRT,
      S.VLR_TOT_IT,
      S.VLR_DESC_IT,
      S.VLR_IPI_IT,
      S.CD_TRIB_FC,
      S.VLR_BASE_ICMS_IT,
      S.ALIQ_ICMS,
      S.VLR_ICMS_IT,
      CASE
          WHEN S.LISTA_PROD = 0
          THEN '0 - POSITIVA'
          WHEN S.LISTA_PROD = 1
          THEN '1 - NEGATIVA'
          WHEN S.LISTA_PROD = 2
          THEN '2 - NEUTRA'
      END AS LISTA_PROD,
      S.CD_NT_OP_FC CFOP,
      S.NR_NCM,
      ISNULL(S.PERC_IVA, 0) AS VLR_PAUTA_IVA,
      CAST(S.VLR_BASE_SUBS AS NUMERIC(15, 4)) AS VLR_BASE_SUBS_IT,
      CAST(S.VLR_ICMS_SUBS AS NUMERIC(15, 4)) AS VLR_ICMS_SUBS_IT,
      S.VLR_TOT_IT + (S.VLR_TOT_IT * (S.PERC_IPI / 100.00)) + (S.VLR_ICMS_SUBS) + (S.VLR_OUTROS_DESPESAS) + CASE
                                                                                                                WHEN S.FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1
                                                                                                                THEN 0
                                                                                                                ELSE(S.VLR_ICMS_RET)
                                                                                                            END AS VLR_TOT_IT_NOTA,
      (S.QT_IT * ISNULL(S.VLR_CUSTO_MD, 0)) VLR_CUSTO_IT_MD,
      0 AS VLR_TABELA,
      (A.VLR_CUSTO_GRP * S.QT_IT) AS VLR_CUSTO_GRP,
      (S.VLR_CUSTO_MD * S.QT_IT) AS VLR_CUSTO_MD,
      S.OBS1,
      S.OBS2,
      S.OBS3,
      S.OBS4,
      S.CGC_CPF,
      S.UF,
      S.ESPC,
      S.SERIE,
      'NO' AS PEND_ENTRADA,
      ' ' AS  NR_PROTOCOLO,
      ' ' AS  NR_AUTORIZADOR,
      CASE
          WHEN ISNULL(
                      (
                          SELECT TOP 1 CD_NF
                          FROM EST_NF_SAI_ARQ_DANFE
                          WHERE S.CD_EMP = EST_NF_SAI_ARQ_DANFE.CD_EMP
                                AND S.CD_FILIAL = EST_NF_SAI_ARQ_DANFE.CD_FILIAL
                                AND S.CD_NF = EST_NF_SAI_ARQ_DANFE.CD_NF
                      ), 0) = 0
          THEN 'NO'
          ELSE 'SIM'
      END XML_ARM_NF,
      CASE
          WHEN S.FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1
          THEN 0
          ELSE ROUND(S.VLR_ICMS_RET, 2)
      END AS VLR_ICMS_RET,
      CASE
          WHEN S.TP_MOV <> 28
          THEN CASE
                    WHEN S.PIS_COFINS = 0
                    THEN 'NO'
                    WHEN S.PIS_COFINS = 1
                    THEN 'SIM'
                END
          ELSE 'NO'
      END AS PIS_COFINS,
      S.VLR_NF,
      0 AS NOTAENTRADA,
      '' AS DT_ENT,
      0 AS NF_ENT_REF,
      0 AS DT_ENT_REF,
      0 AS QT_IT_REF,
      CASE
          WHEN S.ISENTO = 1
          THEN S.VLR_TOT_IT
          ELSE 0
      END AS VLR_ISENTO,
      CASE
          WHEN S.SUBS_TRIB_ANT = 1
          THEN S.VLR_TOT_IT
          ELSE CASE
                    WHEN(S.ICMS + S.SUBS_TRIB + S.ICMS_RD) > 1
                    THEN S.VLR_TOT_IT - S.VLR_BASE_ICMS_IT
                    ELSE 0
                END
      END AS VLR_OUTROS,
      ISNULL(ROUND(S.VLR_OUTROS_DESPESAS, 2), 0) AS VLR_OUTROS_DESPESAS,
	 0 VLR_ICMS_RECUPERAR,
      ISNULL(S.NR_CEST, '') NR_CEST,
      S.NM_USU
FROM V_EST_NF_SAI S
    INNER JOIN V_EST_PROD_ARV_MERCADOLOGICA A ON S.CD_EMP = A.CD_EMP
                                                  AND S.CD_PROD = A.CD_PROD
    INNER JOIN #FILIAIS ON S.CD_EMP = #FILIAIS.CD_EMP 
						 AND S.CD_FILIAL = #FILIAIS.CD_FILIAL 
    INNER JOIN #MOV ON S.CD_EMP = #MOV.CD_EMP 
						 AND S.CD_MOV_OP = #MOV.CD_MOV_OP 
WHERE S.CD_EMP = 1  
AND S.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
AND S.STS_NF = 0 
-----------------------------------------------------------------------------------------------------------------------------------------------------------
PRINT 'DELETE 1 ' +CONVERT (VARCHAR,GETDATE(),108)
-----------------------------------------------------------------------------------------------------------------------------------------------------------

DELETE S FROM #RESULT S
    INNER JOIN EST_NF_SAI_CANCEL ON S.CD_EMP = EST_NF_SAI_CANCEL.CD_EMP
                                          AND S.CD_FILIAL = EST_NF_SAI_CANCEL.CD_FILIAL
                                          AND S.CD_NF = EST_NF_SAI_CANCEL.CD_NF
-----------------------------------------------------------------------------------------------------------------------------------------------------------
PRINT 'UPDATE 1 ' +CONVERT (VARCHAR,GETDATE(),108)
-----------------------------------------------------------------------------------------------------------------------------------------------------------

UPDATE #RESULT SET 
NR_PROTOCOLO= #RESULT.NR_PROTOCOLO + NFE.NR_PROTOCOLO,
NR_AUTORIZADOR = #RESULT.NR_AUTORIZADOR + NFE.NR_AUTORIZADOR
FROM #RESULT 
    INNER JOIN EST_NF_SAI_NFE NFE ON #RESULT.CD_EMP = NFE.CD_EMP
                                    AND #RESULT.CD_FILIAL = NFE.CD_FILIAL
                                    AND #RESULT.CD_NF = NFE.CD_NF 
-----------------------------------------------------------------------------------------------------------------------------------------------------------
PRINT 'UPDATE 2 ' +CONVERT (VARCHAR,GETDATE(),108)
-----------------------------------------------------------------------------------------------------------------------------------------------------------

UPDATE #RESULT SET VLR_TABELA = (VL.VLR_TABELA * QT_IT)
FROM #RESULT
    INNER JOIN EST_PROD_PRECO VL ON #RESULT.CD_EMP = VL.CD_EMP
                                          AND #RESULT.CD_FILIAL = VL.CD_FILIAL
                                          AND #RESULT.CD_PROD = VL.CD_PROD
-----------------------------------------------------------------------------------------------------------------------------------------------------------
PRINT 'UPDATE 3 ' +CONVERT (VARCHAR,GETDATE(),108)
-----------------------------------------------------------------------------------------------------------------------------------------------------------

UPDATE #RESULT SET VLR_ICMS_RECUPERAR = SC.VLR_ICMS_REC
FROM #RESULT INNER JOIN #AUX SC
ON #RESULT.CD_EMP = SC.CD_EMP
        AND #RESULT.CD_FILIAL = SC.CD_FILIAL
        AND #RESULT.CD_NF = SC.CD_NF
        AND #RESULT.CD_PROD = SC.CD_PROD
-----------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------

UPDATE #RESULT SET PEND_ENTRADA = 'SIM'
FROM #RESULT INNER JOIN  EST_NF_SAI_PENDENCIA PEND ON #RESULT.CD_EMP = PEND.CD_EMP
                                            AND #RESULT.CD_FILIAL = PEND.CD_FILIAL
                                            AND #RESULT.CD_NF = PEND.CD_NF 

-----------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------------------------------
    INSERT INTO #RESULT
		  SELECT E.CD_EMP,
			   E.CD_FILIAL,
			   E.CD_NF,
			   E.CD_FORN_FILIAL AS CD_CLI,
			   E.NM_ORIG AS NM_DEST,
			   E.NR_NF AS NF_NF,
			   E.DT_EMI_NF,
			   A.CD_PROD,
			   A.DS_PROD,
			   A.NM_FABRIC,
			   A.DS_ARV_MERC_CATEG,
			   A.DS_ARV_MERC_DEPTO,
			   A.DS_ARV_MERC_AREA_ATEND,
			   A.DS_ARV_MERC_SEG,
			   A.DS_ARV_MERC_LINHA,
			   A.DS_ARV_MERC_PAPEL,
			   A.DS_ARV_MERC_FAMILIA,
			   A.DS_ARV_MERC_MIX,
			   A.DS_ARV_MERC_CONSUMO,
			   CASE
				  WHEN E.STS_NF = 0
				  THEN 'ATIVA'
				  ELSE 'CANCELADA'
			   END AS STS_NF,
			   E.CD_MOV_OP,
			   E.DS_MOV_OP_USUAL,
			   CASE
				  WHEN E.ATU_EST = 1
				  THEN 'ATUALIZOU ESTOQUE'
				  ELSE 'NO ATUALIZOU ESTOQUE'
			   END AS BX_EST,
			   'ENTRADA' AS TIPO_TRANSACAO,
			   E.QT_IT,
			   (E.VLR_TOT_IT + E.VLR_DESC_IT) AS VLR_TOT_IT_BRT,
			   E.VLR_TOT_IT,
			   E.VLR_DESC_IT,
			   E.VLR_IPI_IT,
			   CD_TRIB_FC,
			   E.VLR_BASE_ICMS_IT,
			   E.ALIQ_ICMS,
			   E.VLR_ICMS_IT,
			   CASE
				  WHEN E.LISTA_PROD = 0
				  THEN '0 - POSITIVA'
				  WHEN E.LISTA_PROD = 1
				  THEN '1 - NEGATIVA'
				  WHEN E.LISTA_PROD = 2
				  THEN '2 - NEUTRA'
			   END AS LISTA_PROD,
			   E.CFOP,
			   E.NR_NCM,
			   ISNULL(E.PERC_IVA, 0) AS VLR_PAUTA_IVA,
			   CAST(E.VLR_BASE_SUBS_IT AS NUMERIC(15, 4)) AS VLR_BASE_SUBS_IT,
			   CAST(E.VLR_ICMS_SUBS_IT AS NUMERIC(15, 4)) AS VLR_ICMS_SUBS_IT,
			   (E.VLR_TOT_IT * (E.PERC_IPI / 100)) + (E.VLR_ICMS_SUBS_IT) + CASE
																    WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1
																    THEN 0
																    ELSE(E.VLR_ICMS_RET)
																END AS VLR_TOT_IT_NOTA,
			   (E.QT_IT * ISNULL(E.VLR_CUSTO_MD, 0)) VLR_CUSTO_IT_MD,
			   (ISNULL(VL.VLR_TABELA, 0) * E.QT_IT) AS VLR_TABELA,
			   (A.VLR_CUSTO_GRP * E.QT_IT) AS VLR_CUSTO_GRP,
			   (E.VLR_CUSTO_MD * E.QT_IT) AS VLR_CUSTO_MD,
			   E.OBS1 COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS OBS1,
			   E.OBS2 COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS OBS2,
			   E.OBS3 COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS OBS3,
			   E.OBS4 COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS AS OBS4,
			   E.CGC_CPF,
			   E.UF,
			   E.ESPC,
			   E.SERIE,
			   CASE
				  WHEN ISNULL(PEND.CD_NF, 0) = 0
				  THEN 'NO'
				  ELSE 'SIM'
			   END AS PEND_ENTRADA,
			   ISNULL(NFE.NR_PROTOCOLO, '') NR_PROTOCOLO,
			   ISNULL(NFE.NR_AUTORIZADOR, '') NR_AUTORIZADOR,
			   (CASE
				    WHEN ISNULL(XLMARMAZEDADO.CD_NF, 0) = 0
				    THEN 'NO'
				    ELSE 'SIM'
				END) XML_ARM_NF,
			   CASE
				  WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1
				  THEN 0
				  ELSE ROUND(E.VLR_ICMS_RET, 2)
			   END AS VLR_ICMS_RET,
			   CASE
				  WHEN E.PIS_COFINS = 0
				  THEN 'NO'
				  WHEN E.PIS_COFINS = 1
				  THEN 'SIM'
			   END AS PIS_COFINS,
			   E.VLR_NF,
			   0 AS NOTAENTRADA,
			   CAST('' AS DATE) AS DT_ENT,
			   0 AS NF_ENT_REF,
			   0 AS DT_ENT_REF,
			   0 AS QT_IT_REF,
			   CASE
				  WHEN E.ISENTO = 1
				  THEN E.VLR_TOT_IT
				  ELSE 0
			   END AS VLR_ISENTO,
			   CASE
				  WHEN E.SUBS_TRIB_ANT = 1
				  THEN E.VLR_TOT_IT
				  ELSE CASE
						  WHEN(ICMS + SUBS_TRIB + ICMS_RD) > 1
						  THEN E.VLR_TOT_IT - E.VLR_BASE_ICMS_IT
						  ELSE 0
					   END
			   END AS VLR_OUTROS,
			   0 AS VLR_OUTROS_DESPESAS,
			   0 VLR_ICMS_RECUP,
			   ISNULL(E.NR_CEST, '') AS NR_CEST,
			   NM_USU
		  FROM V_EST_NF_ENT E
			 INNER JOIN V_EST_PROD_ARV_MERCADOLOGICA A ON E.CD_EMP = A.CD_EMP
												  AND E.CD_PROD = A.CD_PROD
			 LEFT JOIN EST_NF_ENT_ARQ_DANFE XLMARMAZEDADO ON E.CD_EMP = XLMARMAZEDADO.CD_EMP
												    AND E.CD_FILIAL = XLMARMAZEDADO.CD_FILIAL
												    AND E.CD_NF = XLMARMAZEDADO.CD_NF
			 LEFT OUTER JOIN EST_PROD_PRECO VL ON E.CD_EMP = VL.CD_EMP
										    AND E.CD_FILIAL = VL.CD_FILIAL
										    AND E.CD_PROD = VL.CD_PROD
			 LEFT JOIN EST_NF_SAI_PENDENCIA PEND ON E.CD_EMP = PEND.CD_EMP
											 AND E.CD_FILIAL = PEND.CD_FILIAL
											 AND E.CD_NF = PEND.CD_NF
			 LEFT JOIN EST_NF_ENT_NFE NFE ON E.CD_EMP = NFE.CD_EMP
									   AND E.CD_FILIAL = NFE.CD_FILIAL
									   AND E.CD_NF = NFE.CD_NF
			 INNER JOIN EST_NF_ENT_EF_NF_CTR_NF CTRNUMERACAO ON E.CD_EMP = CTRNUMERACAO.CD_EMP
													   AND E.CD_FILIAL = CTRNUMERACAO.CD_FILIAL
													   AND E.CD_NF = CTRNUMERACAO.CD_NF_ENT
													   AND E.CD_NF_SERIE = CTRNUMERACAO.CD_NF_SERIE
			 INNER JOIN #FILIAIS ON E.CD_EMP = #FILIAIS.CD_EMP 
								   AND E.CD_FILIAL = #FILIAIS.CD_FILIAL 
			 INNER JOIN #MOV ON E.CD_EMP = #MOV.CD_EMP 
								   AND E.CD_MOV_OP = #MOV.CD_MOV_OP 
		  WHERE E.CD_EMP = 1
		  AND DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
		  AND E.STS_NF = 0;

SELECT 
	  * 
FROM #RESULT